library(dplyr)
library(ggplot2)
library(RColorBrewer)
library(forcats)
#----------------------------------------------------
# directory 
setwd('/Users/mi/Desktop/FDI Russia/ver 3')
getwd()
#----------------------------------------------------
# Loading data

data <-
  read.table('rus_choro2.csv',
             sep = ",",
             dec = ".",
             header = TRUE)


data <-
  read.table('rus_sector.csv',
             sep = ",",
             dec = ".",
             header = TRUE)



# for Partners
df <- data %>% arrange (inward.FDI) %>%
  mutate(partner=factor(partner, levels=partner))

# for sectors
df <- data %>% arrange (FDI.stock) %>%
  mutate(sector = factor(sector, levels = sector))

#---------------------------------------------------- image size 770 x 730
# Partner graph
ggplot(df, aes(x=partner, y=inward.FDI)) + 
  geom_bar(stat = "identity", fill = 'lightslategrey') + coord_flip() + theme(legend.position = "none") +
  theme_classic() + ScaleContinuous + 
  geom_text(stat = "identity", aes(label = round(inward.FDI, 2))) +
  labs (x ="partner", y = "inward FDI in $US billion")

# Sector graph
  
ggplot(df, aes(x = sector, y = FDI.stock)) + 
  geom_bar(stat = "identity", fill = 'lightslategrey') + coord_flip() + theme(legend.position = "none") +
  theme_classic() + ScaleContinuous + 
  geom_text(stat = "identity", aes(label = round(FDI.stock, 2))) +
  labs (x ="sector", y = "FDI stock in $US billion")



